/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.HealpixKey;
import cds.aladin.HealpixKeyPol;
import cds.aladin.PlanBG;
import cds.tools.Util;
import cds.tools.pixtools.Hpix;

class HealpixAllskyPol
extends HealpixKeyPol {
    protected int nbPix;
    protected HealpixKey[] pixList;
    protected int order;

    protected HealpixAllskyPol(PlanBG planBG, int order) {
        this.planBG = planBG;
        this.order = order;
        this.npix = -1L;
        this.allSky = true;
        this.resetTimer();
        String nameNet = "Norder" + order + "/Allsky";
        String nameCache = planBG.getCacheName() + "/Norder" + order + "/Allsky";
        this.extCache = this.extNet = planBG.getTileMode();
        this.fileCache = nameCache + EXT[this.extCache];
        this.fileNet = nameNet + EXT[this.extNet];
        this.alreadyCached = false;
        this.priority = -1;
        this.nbPix = 12 * (int)Math.pow(4.0, order);
        this.pixList = null;
        this.setStatus(1);
    }

    HealpixKeyPol createOneKey(int npix, int width, byte[] pix1, byte[] pix2) {
        HealpixKeyPol h = new HealpixKeyPol();
        h.planBG = this.planBG;
        h.order = this.order;
        h.npix = npix;
        h.hpix = new Hpix(this.order, npix, this.planBG.frameOrigin);
        h.resetTimer();
        h.width = h.height = width;
        h.pixels = null;
        h.bitpix = this.bitpix;
        h.pixelsOrigin = pix1;
        h.bitpix2 = this.bitpix2;
        h.pixelsOrigin2 = pix2;
        h.alreadyCached = true;
        h.allSky = true;
        h.setStatus(6);
        return h;
    }

    public int getOrder1() {
        return this.order;
    }

    public long getNpix() {
        return -1L;
    }

    protected void createPixList() {
        if (this.getStatus() != 6) {
            return;
        }
        int nbLosangeWidth = (int)Math.sqrt(this.nbPix);
        int nbLosangeHeight = this.nbPix / nbLosangeWidth;
        if ((double)(this.nbPix / nbLosangeWidth) != (double)this.nbPix / (double)nbLosangeWidth) {
            ++nbLosangeHeight;
        }
        int w = this.width / nbLosangeWidth;
        this.pixList = new HealpixKey[this.nbPix];
        for (int i = 0; i < this.nbPix; ++i) {
            byte[] pix1 = null;
            byte[] pix2 = null;
            int npix1 = 0;
            int npix2 = 0;
            if (this.bitpix != 0) {
                npix1 = Math.abs(this.bitpix) / 8;
                pix1 = new byte[w * w * npix1];
            }
            if (this.bitpix2 != 0) {
                npix2 = Math.abs(this.bitpix2) / 8;
                pix2 = new byte[w * w * npix2];
            }
            int yLosange = i / nbLosangeWidth * w;
            int xLosange = i % nbLosangeWidth * w;
            if (i % 100 == 0) {
                Util.pause(10);
            }
            for (int y = 0; y < w; ++y) {
                for (int x = 0; x < w; ++x) {
                    int offset = (yLosange + y) * this.width + (xLosange + x);
                    int pos = y * w + x;
                    if (this.bitpix != 0) {
                        System.arraycopy(this.pixelsOrigin, offset * npix1, pix1, pos * npix1, npix1);
                    }
                    if (this.bitpix2 == 0) continue;
                    System.arraycopy(this.pixelsOrigin2, offset * npix2, pix2, pos * npix2, npix2);
                }
            }
            this.pixList[i] = this.createOneKey(i, w, pix1, pix2);
        }
        this.pixels = null;
        this.pixelsOrigin2 = null;
        this.pixelsOrigin = null;
    }

    @Override
    protected int free() {
        int n = 0;
        if (this.pixList != null) {
            n = this.pixList.length;
            for (int j = 0; j < this.pixList.length; ++j) {
                this.pixList[j].free();
            }
        }
        this.pixList = null;
        return n;
    }

    @Override
    protected void clearBuf() {
        if (this.pixList == null) {
            return;
        }
        for (int j = 0; j < this.pixList.length; ++j) {
            this.pixList[j].clearBuf();
        }
    }

    @Override
    HealpixKey[] getPixList() {
        if (this.pixList == null) {
            this.createPixList();
        }
        return this.pixList;
    }
}

